/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.text.Html;
import android.text.TextUtils;
import android.util.Pair;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.MailShareContent;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.io.File;
import java.util.List;

public class EmailHandler
extends UMSSOHandler {
    private static final String TAG = "umengsocial";
    protected String VERSION = "6.8.2";
    private static final String[][] MIME_MapTable = new String[][]{{".3gp", "video/3gpp"}, {".apk", "application/vnd.android.package-archive"}, {".asf", "video/x-ms-asf"}, {".avi", "video/x-msvideo"}, {".bin", "application/octet-stream"}, {".bmp", "image/bmp"}, {".c", "text/plain"}, {".class", "application/octet-stream"}, {".conf", "text/plain"}, {".cpp", "text/plain"}, {".doc", "application/msword"}, {".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"}, {".xls", "application/vnd.ms-excel"}, {".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}, {".exe", "application/octet-stream"}, {".gif", "image/gif"}, {".gtar", "application/x-gtar"}, {".gz", "application/x-gzip"}, {".h", "text/plain"}, {".htm", "text/html"}, {".html", "text/html"}, {".jar", "application/java-archive"}, {".java", "text/plain"}, {".jpeg", "image/jpeg"}, {".jpg", "image/jpeg"}, {".js", "application/x-javascript"}, {".log", "text/plain"}, {".m3u", "audio/x-mpegurl"}, {".m4a", "audio/mp4a-latm"}, {".m4b", "audio/mp4a-latm"}, {".m4p", "audio/mp4a-latm"}, {".m4u", "video/vnd.mpegurl"}, {".m4v", "video/x-m4v"}, {".mov", "video/quicktime"}, {".mp2", "audio/x-mpeg"}, {".mp3", "audio/x-mpeg"}, {".mp4", "video/mp4"}, {".mpc", "application/vnd.mpohun.certificate"}, {".mpe", "video/mpeg"}, {".mpeg", "video/mpeg"}, {".mpg", "video/mpeg"}, {".mpg4", "video/mp4"}, {".mpga", "audio/mpeg"}, {".msg", "application/vnd.ms-outlook"}, {".ogg", "audio/ogg"}, {".pdf", "application/pdf"}, {".png", "image/png"}, {".pps", "application/vnd.ms-powerpoint"}, {".ppt", "application/vnd.ms-powerpoint"}, {".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation"}, {".prop", "text/plain"}, {".rc", "text/plain"}, {".rmvb", "audio/x-pn-realaudio"}, {".rtf", "application/rtf"}, {".sh", "text/plain"}, {".tar", "application/x-tar"}, {".tgz", "application/x-compressed"}, {".txt", "text/plain"}, {".wav", "audio/x-wav"}, {".wma", "audio/x-ms-wma"}, {".wmv", "audio/x-ms-wmv"}, {".wps", "application/vnd.ms-works"}, {".xml", "text/plain"}, {".z", "application/x-compress"}, {".zip", "application/x-zip-compressed"}, {"", "*/*"}};

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        Log.um((String)(p.getName() + " version:" + this.VERSION));
    }

    public boolean share(ShareContent content, UMShareListener listener) {
        return this.shareTo(new MailShareContent(content), listener);
    }

    public boolean shareTo(SimpleShareContent shareContent, final UMShareListener listener) {
        Uri imgUri;
        File file;
        MailShareContent content = (MailShareContent)shareContent;
        String title = "";
        String subject = content.getSubject();
        String textcontent = content.getText();
        File sharefile = content.getFile();
        UMImage shareImg = content.getImage();
        UMusic mMusic = content.getMusic();
        UMVideo mVideo = content.getVideo();
        Intent sendIntent = new Intent("android.intent.action.SEND");
        if (shareContent.getmStyle() == 16 || shareContent.getmStyle() == 4 || shareContent.getmStyle() == 8) {
            textcontent = textcontent + content.getBaseMediaObject().toUrl();
            title = textcontent + content.getBaseMediaObject().getTitle();
        }
        sendIntent.putExtra("android.intent.extra.TITLE", title);
        sendIntent.setType("message/rfc822");
        sendIntent.putExtra("android.intent.extra.SUBJECT", subject);
        if (!TextUtils.isEmpty((CharSequence)textcontent)) {
            sendIntent.putExtra("android.intent.extra.TEXT", (CharSequence)Html.fromHtml((String)textcontent));
        }
        if (sharefile != null) {
            String type = EmailHandler.getMIMEType(sharefile);
            sendIntent.setDataAndType(Uri.fromFile((File)sharefile), type);
        } else if (shareImg != null && (file = shareImg.asFileImage()) != null && (imgUri = SocializeUtils.insertImage((Context)this.getContext(), (String)file.toString())) != null) {
            sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)imgUri);
            sendIntent.setType("image/png;message/rfc822");
            SocializeUtils.deleteUris.add(imgUri);
        }
        Pair<String, String> p = this.getPackageInfo(this.getContext(), sendIntent);
        if (p != null) {
            sendIntent.setClassName((String)p.first, (String)p.second);
        }
        try {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onResult(SHARE_MEDIA.EMAIL);
                }
            });
            if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                ((Activity)this.mWeakAct.get()).startActivity(sendIntent);
            }
            return true;
        }
        catch (Throwable e) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.EMAIL, new Throwable(UmengErrorCode.UnKnowCode.getMessage() + e.getMessage()));
                }
            });
            return false;
        }
    }

    private Pair<String, String> getPackageInfo(Context context, Intent intent) {
        Pair package_activity = null;
        try {
            PackageManager pm = context.getPackageManager();
            List matches = pm.queryIntentActivities(intent, 0);
            ResolveInfo best = null;
            for (ResolveInfo info : matches) {
                if (!info.activityInfo.packageName.endsWith(".gm") && !info.activityInfo.name.toLowerCase().contains("gmail")) continue;
                best = info;
            }
            if (best != null) {
                package_activity = new Pair((Object)best.activityInfo.packageName, (Object)best.activityInfo.name);
            } else {
                Log.w((String)"no found gmail package...");
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"", (Exception)e);
        }
        return package_activity;
    }

    public static String getMIMEType(File file) {
        String type = "*/*";
        String fName = file.getName();
        int dotIndex = fName.lastIndexOf(".");
        if (dotIndex < 0) {
            return type;
        }
        String end = fName.substring(dotIndex, fName.length()).toLowerCase();
        if (end == "") {
            return type;
        }
        for (int i = 0; i < MIME_MapTable.length; ++i) {
            if (!end.equals(MIME_MapTable[i][0])) continue;
            type = MIME_MapTable[i][1];
        }
        return type;
    }
}

