/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;

public class QQPreferences {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String OPENID = "openid";
    private static final String UID = "uid";
    private static final String UNIONID = "unionid";
    private static final String EXPIRES_IN = "expires_in";
    private String mAccessToken = null;
    private static long mtl = 0L;
    private String mUID = null;
    private String unionid = null;
    private String mOpenid = null;
    private SharedPreferences sharedPreferences = null;

    public QQPreferences(Context context, String platform) {
        this.sharedPreferences = context.getSharedPreferences(platform + "full", 0);
        this.mAccessToken = this.sharedPreferences.getString(ACCESS_TOKEN, null);
        this.mUID = this.sharedPreferences.getString(UID, null);
        this.mOpenid = this.sharedPreferences.getString(OPENID, null);
        mtl = this.sharedPreferences.getLong(EXPIRES_IN, 0L);
        this.unionid = this.sharedPreferences.getString(UNIONID, null);
    }

    public String getmAccessToken() {
        return this.mAccessToken;
    }

    public void setmUID(String mUID) {
        this.mUID = mUID;
    }

    public void setUnionid(String unionid) {
        this.unionid = unionid;
    }

    public String getUnionid() {
        return this.unionid;
    }

    public void setmOpenid(String mOpenid) {
        this.mOpenid = mOpenid;
    }

    public static long getExpiresIn() {
        return mtl;
    }

    public String getmUID() {
        return this.mUID;
    }

    public QQPreferences setAuthData(Bundle b) {
        this.mAccessToken = b.getString(ACCESS_TOKEN);
        mtl = Long.valueOf(b.getString(EXPIRES_IN)) * 1000L + System.currentTimeMillis();
        this.mOpenid = b.getString(OPENID);
        this.mUID = b.getString(OPENID);
        this.unionid = b.getString(UNIONID);
        return this;
    }

    public boolean isAuthValid() {
        boolean isExpired = mtl - System.currentTimeMillis() <= 0L;
        return this.mAccessToken != null && !isExpired;
    }

    public void commit() {
        this.sharedPreferences.edit().putString(ACCESS_TOKEN, this.mAccessToken).putLong(EXPIRES_IN, mtl).putString(UID, this.mUID).putString(OPENID, this.mOpenid).putString(UNIONID, this.unionid).commit();
    }

    public void delete() {
        this.mAccessToken = null;
        mtl = 0L;
        this.sharedPreferences.edit().clear().commit();
    }
}

