/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.utils;

import android.net.Uri;
import android.text.TextUtils;
import com.umeng.socialize.Config;
import com.umeng.socialize.net.utils.URequest;
import com.umeng.socialize.net.utils.UResponse;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.UmengText;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public class UClient {
    private static final String TAG = "UClient";
    private static final String END = "\r\n";

    public <T extends UResponse> T execute(URequest uRequest, Class<T> clazz) {
        uRequest.onPrepareRequest();
        String string = uRequest.getHttpMethod().trim();
        this.verifyMethod(string);
        ResponseObj responseObj = null;
        if (URequest.GET.equals(string)) {
            responseObj = this.httpGetRequest(uRequest);
        } else if (URequest.POST.equals(string)) {
            responseObj = this.httpPostRequest(uRequest);
        }
        T t = this.createResponse(responseObj, clazz);
        return t;
    }

    protected <T extends UResponse> T createResponse(ResponseObj responseObj, Class<T> clazz) {
        if (responseObj == null) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(Integer.class, JSONObject.class);
            return (T)((UResponse)constructor.newInstance(responseObj.httpResponseCode, responseObj.jsonObject));
        }
        catch (SecurityException securityException) {
            Log.e(TAG, "SecurityException", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e(TAG, "NoSuchMethodException", noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e(TAG, "IllegalArgumentException", illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            Log.e(TAG, "InstantiationException", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e(TAG, "IllegalAccessException", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e(TAG, "InvocationTargetException", invocationTargetException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObj httpPostRequest(URequest uRequest) {
        String string = uRequest.toJson() == null ? "" : uRequest.toJson().toString();
        Log.net("URequest  = " + uRequest.getClass().getName());
        String string2 = UUID.randomUUID().toString();
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            Object object;
            String string32;
            String string4;
            httpURLConnection = this.openUrlConnection(uRequest);
            if (httpURLConnection == null) {
                ResponseObj responseObj = null;
                return responseObj;
            }
            Map<String, Object> map = uRequest.getBodyPair();
            if (uRequest.mMimeType != null) {
                string4 = (String)map.get("data");
                httpURLConnection.setRequestProperty("Content-Type", uRequest.mMimeType.toString());
                outputStream = httpURLConnection.getOutputStream();
                outputStream.write(string4.getBytes());
            } else if (uRequest.postStyle == URequest.PostStyle.APPLICATION) {
                Log.net("message:" + string);
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                string4 = new Uri.Builder();
                for (String string32 : map.keySet()) {
                    try {
                        string4.appendQueryParameter(string32, map.get(string32).toString());
                    }
                    catch (Error error) {
                        Log.um("upload error=" + error.getMessage());
                    }
                }
                object = string4.build().getEncodedQuery();
                outputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                outputStream.write(((String)object).getBytes());
            } else if (map != null && map.size() > 0 || uRequest.postStyle == URequest.PostStyle.MULTIPART) {
                httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string2);
                outputStream = httpURLConnection.getOutputStream();
                this.addBodyParams(uRequest, outputStream, string2);
            } else {
                Log.net("message:" + string);
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                string4 = new Uri.Builder();
                string4.appendQueryParameter("content", string);
                object = string4.build().getEncodedQuery();
                outputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                outputStream.write(((String)object).getBytes());
            }
            outputStream.flush();
            int n = httpURLConnection.getResponseCode();
            object = new ResponseObj();
            ((ResponseObj)object).httpResponseCode = n;
            if (n == 200) {
                inputStream = httpURLConnection.getInputStream();
                string32 = httpURLConnection.getContentEncoding();
                JSONObject jSONObject = this.parseResult(uRequest, httpURLConnection.getRequestMethod(), string32, inputStream);
                Log.net("requestMethod:POST;json data:" + jSONObject);
                ((ResponseObj)object).jsonObject = jSONObject;
                Object object2 = object;
                this.closeQuietly(inputStream);
                this.closeQuietly(outputStream);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return object2;
            }
            string32 = null;
            this.closeQuietly(inputStream);
            this.closeQuietly(outputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return string32;
        }
        catch (IOException iOException) {
            Log.e(TAG, "Caught Exception in httpPostRequest()", iOException);
        }
        finally {
            this.closeQuietly(inputStream);
            this.closeQuietly(outputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseObj httpGetRequest(URequest uRequest) {
        InputStream inputStream = null;
        HttpURLConnection httpURLConnection = null;
        Log.net("URequest  = " + uRequest.getClass().getName());
        try {
            httpURLConnection = this.openUrlConnection(uRequest);
            if (httpURLConnection == null) {
                ResponseObj responseObj = null;
                return responseObj;
            }
            int n = httpURLConnection.getResponseCode();
            ResponseObj responseObj = new ResponseObj();
            responseObj.httpResponseCode = n;
            if (n == 200) {
                JSONObject jSONObject;
                inputStream = httpURLConnection.getInputStream();
                String string = httpURLConnection.getContentEncoding();
                responseObj.jsonObject = jSONObject = this.parseResult(uRequest, httpURLConnection.getRequestMethod(), string, inputStream);
                Log.net("result  = " + jSONObject);
                ResponseObj responseObj2 = responseObj;
                this.closeQuietly(inputStream);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return responseObj2;
            }
            ResponseObj responseObj3 = null;
            this.closeQuietly(inputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return responseObj3;
        }
        catch (Exception exception) {
            Log.e(TAG, "Caught Exception in httpGetRequest()", exception);
        }
        finally {
            this.closeQuietly(inputStream);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return null;
    }

    private HttpURLConnection openUrlConnection(URequest uRequest) throws IOException {
        String string = uRequest.getHttpMethod().trim();
        String string2 = null;
        if (URequest.GET.equals(string)) {
            string2 = uRequest.toGetUrl();
        } else if (URequest.POST.equals(string)) {
            string2 = uRequest.mBaseUrl;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        URL uRL = new URL(string2);
        String string3 = uRL.getProtocol();
        boolean bl = false;
        if ("https".equals(string3)) {
            bl = true;
        }
        HttpURLConnection httpURLConnection = bl ? (HttpsURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(Config.connectionTimeOut);
        httpURLConnection.setReadTimeout(Config.readSocketTimeOut);
        httpURLConnection.setRequestMethod(string);
        if (URequest.GET.equals(string)) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip");
            if (uRequest.mHeaders != null && uRequest.mHeaders.size() > 0) {
                Set<String> set = uRequest.mHeaders.keySet();
                for (String string4 : set) {
                    httpURLConnection.setRequestProperty(string4, uRequest.mHeaders.get(string4));
                }
            }
        } else if (URequest.POST.equals(string)) {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
        }
        return httpURLConnection;
    }

    private void verifyMethod(String string) {
        String string2 = string;
        if (TextUtils.isEmpty((CharSequence)string2) || !(URequest.GET.equals(string2.trim()) ^ URequest.POST.equals(string2.trim()))) {
            throw new RuntimeException(UmengText.netMethodError(string2));
        }
    }

    private void addBodyParams(URequest uRequest, OutputStream outputStream, String string) throws IOException {
        Object object;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Object> map = uRequest.getBodyPair();
        Set<String> set = map.keySet();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (map.get(object) == null) continue;
            this.addFormField(stringBuilder, (String)object, map.get(object).toString(), string);
        }
        if (stringBuilder.length() > 0) {
            bl = true;
            outputStream = new DataOutputStream(outputStream);
            outputStream.write(stringBuilder.toString().getBytes());
        }
        if ((object2 = uRequest.getFilePair()) != null && object2.size() > 0) {
            object = object2.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                URequest.FilePair filePair = (URequest.FilePair)object2.get(string2);
                byte[] byArray = filePair.mBinaryData;
                if (byArray == null || byArray.length < 1) continue;
                bl = true;
                this.addFilePart(filePair.mFileName, byArray, string, outputStream);
            }
        }
        if (bl) {
            this.finishWrite(outputStream, string);
        }
    }

    private void addFormField(StringBuilder stringBuilder, String string, String string2, String string3) {
        stringBuilder.append("--").append(string3).append(END).append("Content-Disposition: form-data; name=\"").append(string).append("\"").append(END).append("Content-Type: text/plain; charset=").append("UTF-8").append(END).append(END).append(string2).append(END);
    }

    private void addFilePart(String string, byte[] byArray, String string2, OutputStream outputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--").append(string2).append(END).append("Content-Disposition: form-data; name=\"").append("pic").append("\"; filename=\"").append(string).append("\"").append(END).append("Content-Type: ").append("application/octet-stream").append(END).append("Content-Transfer-Encoding: binary").append(END).append(END);
        outputStream.write(stringBuilder.toString().getBytes());
        outputStream.write(byArray);
        outputStream.write(END.getBytes());
    }

    private void finishWrite(OutputStream outputStream, String string) throws IOException {
        outputStream.write(END.getBytes());
        outputStream.write(("--" + string + "--").getBytes());
        outputStream.write(END.getBytes());
        outputStream.flush();
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected JSONObject parseResult(URequest uRequest, String string, String string2, InputStream inputStream) {
        block13: {
            InputStream inputStream2 = null;
            try {
                inputStream2 = this.wrapStream(string2, inputStream);
                String string3 = this.convertStreamToString(inputStream2);
                Log.net("requestMethod:" + string + ";origin data:" + string3);
                if ("POST".equals(string)) {
                    try {
                        JSONObject jSONObject = new JSONObject(string3);
                        return jSONObject;
                    }
                    catch (Exception exception) {
                        JSONObject jSONObject = this.decryptData(uRequest, string3);
                        this.closeQuietly(inputStream2);
                        return jSONObject;
                    }
                }
                if ("GET".equals(string)) {
                    if (TextUtils.isEmpty((CharSequence)string3)) {
                        JSONObject jSONObject = null;
                        return jSONObject;
                    }
                    JSONObject jSONObject = this.decryptData(uRequest, string3);
                    return jSONObject;
                }
                break block13;
                {
                    catch (IOException iOException) {
                        Log.e(TAG, "Caught IOException in parseResult()", iOException);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeQuietly(inputStream2);
            }
        }
        return null;
    }

    protected InputStream wrapStream(String string, InputStream inputStream) throws IOException {
        if (string == null || "identity".equalsIgnoreCase(string)) {
            return inputStream;
        }
        if ("gzip".equalsIgnoreCase(string)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equalsIgnoreCase(string)) {
            return new InflaterInputStream(inputStream, new Inflater(false), 512);
        }
        throw new RuntimeException("unsupported content-encoding: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertStreamToString(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 512);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
        }
        catch (IOException iOException) {
            Log.e(TAG, "Caught IOException in convertStreamToString()", iOException);
            String string = null;
            return string;
        }
        finally {
            this.closeQuietly(inputStreamReader);
            this.closeQuietly(bufferedReader);
        }
        return stringBuilder.toString();
    }

    private JSONObject decryptData(URequest uRequest, String string) {
        try {
            String string2 = uRequest.getDecryptString(string);
            return new JSONObject(string2);
        }
        catch (Exception exception) {
            Log.e(TAG, "Caught Exception in decryptData()", exception);
            return null;
        }
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            Log.e(TAG, "Caught IOException in closeQuietly()", iOException);
        }
    }

    protected static class ResponseObj {
        public JSONObject jsonObject;
        public int httpResponseCode;

        protected ResponseObj() {
        }
    }
}

