/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import com.umeng.social.tool.UMImageMark;
import com.umeng.socialize.a.a.a;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.net.utils.SocializeProtocolConstants;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UmengText;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class UMImage
extends BaseMediaObject {
    private ConfiguredConvertor f = null;
    public boolean isLoadImgByCompress = true;
    private UMImage g;
    public CompressStyle compressStyle = CompressStyle.SCALE;
    public Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
    private UMImageMark h;
    private int i = 0;
    private boolean j;
    public static int MAX_WIDTH = 768;
    public static int MAX_HEIGHT = 1024;
    public static int FILE_IMAGE = 1;
    public static int URL_IMAGE = 2;
    public static int RES_IMAGE = 3;
    public static int BITMAP_IMAGE = 4;
    public static int BINARY_IMAGE = 5;

    public UMImage(Context context, File file) {
        this.a(context, file);
    }

    public UMImage(Context context, String string) {
        super(string);
        this.a((Context)new WeakReference<Context>(context).get(), string);
    }

    public UMImage(Context context, int n) {
        this.a(context, (Object)n);
    }

    public UMImage(Context context, byte[] byArray) {
        this.a(context, byArray);
    }

    public UMImage(Context context, Bitmap bitmap) {
        this.a(context, bitmap);
    }

    public UMImage(Context context, Bitmap bitmap, UMImageMark uMImageMark) {
        this.a(context, bitmap, uMImageMark);
    }

    public UMImage(Context context, int n, UMImageMark uMImageMark) {
        this.a(context, n, uMImageMark);
    }

    public UMImage(Context context, byte[] byArray, UMImageMark uMImageMark) {
        this.a(context, byArray, uMImageMark);
    }

    private void a(Context context, Object object) {
        this.a(context, object, null);
    }

    private void a(Context context, Object object, UMImageMark uMImageMark) {
        if (uMImageMark != null) {
            this.j = true;
            this.h = uMImageMark;
            this.h.setContext(context);
        }
        if (ContextUtil.getContext() == null) {
            ContextUtil.setContext(context.getApplicationContext());
        }
        if (object instanceof File) {
            this.i = FILE_IMAGE;
            this.f = new FileConvertor((File)object);
        } else if (object instanceof String) {
            this.i = URL_IMAGE;
            this.f = new UrlConvertor((String)object);
        } else if (object instanceof Integer) {
            this.i = RES_IMAGE;
            Bitmap bitmap = null;
            if (this.isHasWaterMark()) {
                bitmap = this.a(context, (Integer)object);
            }
            this.f = bitmap != null ? new BitmapConvertor(bitmap) : new ResConvertor(context.getApplicationContext(), (Integer)object);
        } else if (object instanceof byte[]) {
            this.i = BINARY_IMAGE;
            Bitmap bitmap = null;
            if (this.isHasWaterMark()) {
                bitmap = this.a((byte[])object);
            }
            this.f = bitmap != null ? new BitmapConvertor(bitmap) : new BinaryConvertor((byte[])object);
        } else if (object instanceof Bitmap) {
            this.i = BITMAP_IMAGE;
            Bitmap bitmap = null;
            if (this.isHasWaterMark()) {
                bitmap = this.a((Bitmap)object, true);
            }
            if (bitmap == null) {
                bitmap = (Bitmap)object;
            }
            this.f = new BitmapConvertor(bitmap);
        } else {
            throw new RuntimeException(UmengText.UNKNOW_UMIMAGE);
        }
    }

    @Override
    public byte[] toByte() {
        return this.asBinImage();
    }

    @Override
    public void setThumb(UMImage uMImage) {
        this.g = uMImage;
    }

    @Override
    public UMImage getThumbImage() {
        return this.g;
    }

    @Override
    public final Map<String, Object> toUrlExtraParams() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.isUrlMedia()) {
            hashMap.put(SocializeProtocolConstants.PROTOCOL_KEY_FURL, this.a);
            hashMap.put(SocializeProtocolConstants.PROTOCOL_KEY_FTYPE, (Object)this.getMediaType());
        }
        return hashMap;
    }

    @Override
    public UMediaObject.MediaType getMediaType() {
        return UMediaObject.MediaType.IMAGE;
    }

    public int getImageStyle() {
        return this.i;
    }

    public File asFileImage() {
        return this.f == null ? null : this.f.asFile();
    }

    public String asUrlImage() {
        return this.f == null ? null : this.f.asUrl();
    }

    public byte[] asBinImage() {
        return this.f == null ? null : this.f.asBinary();
    }

    public Bitmap asBitmap() {
        return this.f == null ? null : this.f.asBitmap();
    }

    private Bitmap a(Bitmap bitmap, boolean bl) {
        if (this.h == null) {
            return bitmap;
        }
        if (bitmap == null) {
            return null;
        }
        try {
            if (bl) {
                bitmap = this.a(bitmap);
            }
            return this.h.compound(bitmap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap a(Context context, int n) {
        if (n == 0 || context == null || this.h == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            inputStream = context.getResources().openRawResource(n);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            this.a(inputStream);
            int n2 = (int)this.a(options.outWidth, options.outHeight, MAX_WIDTH, MAX_HEIGHT);
            if (n2 > 0) {
                options.inSampleSize = n2;
            }
            options.inJustDecodeBounds = false;
            inputStream = context.getResources().openRawResource(n);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            Bitmap bitmap2 = this.a(bitmap, false);
            this.a(inputStream);
            return bitmap2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.a(inputStream);
        }
        return null;
    }

    private void a(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Bitmap a(byte[] byArray) {
        if (byArray == null || this.h == null) {
            return null;
        }
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
            int n = (int)this.a(options.outWidth, options.outHeight, MAX_WIDTH, MAX_HEIGHT);
            if (n > 0) {
                options.inSampleSize = n;
            }
            options.inJustDecodeBounds = false;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
            return this.a(bitmap, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Bitmap a(Bitmap bitmap) {
        int n;
        int n2 = bitmap.getWidth();
        float f = this.a(n2, n = bitmap.getHeight(), MAX_WIDTH, MAX_HEIGHT);
        if (f < 0.0f) {
            return bitmap;
        }
        f = 1.0f / f;
        Matrix matrix = new Matrix();
        matrix.postScale(f, f);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n, (Matrix)matrix, (boolean)false);
        this.b(bitmap);
        return bitmap2;
    }

    private float a(float f, float f2, float f3, float f4) {
        if (f <= f4 && f2 <= f4) {
            return -1.0f;
        }
        float f5 = f / f3;
        float f6 = f2 / f4;
        return f5 > f6 ? f5 : f6;
    }

    private void b(Bitmap bitmap) {
        try {
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isHasWaterMark() {
        return this.j;
    }

    static interface IImageConvertor {
        public File asFile();

        public String asUrl();

        public byte[] asBinary();

        public Bitmap asBitmap();
    }

    static abstract class ConfiguredConvertor
    implements IImageConvertor {
        ConfiguredConvertor() {
        }
    }

    class ResConvertor
    extends ConfiguredConvertor {
        private Context b;
        private int c = 0;

        public ResConvertor(Context context, int n) {
            this.b = context;
            this.c = n;
        }

        @Override
        public File asFile() {
            if (SocializeUtils.assertBinaryInvalid(this.asBinary())) {
                return com.umeng.socialize.a.a.a.b(this.asBinary());
            }
            return null;
        }

        @Override
        public String asUrl() {
            return null;
        }

        @Override
        public byte[] asBinary() {
            return com.umeng.socialize.a.a.a.a(this.b, this.c, UMImage.this.isLoadImgByCompress, UMImage.this.compressFormat);
        }

        @Override
        public Bitmap asBitmap() {
            if (SocializeUtils.assertBinaryInvalid(this.asBinary())) {
                return com.umeng.socialize.a.a.a.a(this.asBinary());
            }
            return null;
        }
    }

    class BinaryConvertor
    extends ConfiguredConvertor {
        private byte[] b;

        public BinaryConvertor(byte[] byArray) {
            this.b = byArray;
        }

        @Override
        public File asFile() {
            if (SocializeUtils.assertBinaryInvalid(this.asBinary())) {
                return com.umeng.socialize.a.a.a.b(this.asBinary());
            }
            return null;
        }

        @Override
        public String asUrl() {
            return null;
        }

        @Override
        public byte[] asBinary() {
            return this.b;
        }

        @Override
        public Bitmap asBitmap() {
            if (SocializeUtils.assertBinaryInvalid(this.asBinary())) {
                return com.umeng.socialize.a.a.a.a(this.asBinary());
            }
            return null;
        }
    }

    class UrlConvertor
    extends ConfiguredConvertor {
        private String b = null;

        public UrlConvertor(String string) {
            this.b = string;
        }

        @Override
        public File asFile() {
            if (SocializeUtils.assertBinaryInvalid(this.asBinary())) {
                return com.umeng.socialize.a.a.a.b(this.asBinary());
            }
            return null;
        }

        @Override
        public String asUrl() {
            return this.b;
        }

        @Override
        public byte[] asBinary() {
            return com.umeng.socialize.a.a.a.a(this.b);
        }

        @Override
        public Bitmap asBitmap() {
            if (SocializeUtils.assertBinaryInvalid(this.asBinary())) {
                return com.umeng.socialize.a.a.a.a(this.asBinary());
            }
            return null;
        }
    }

    class FileConvertor
    extends ConfiguredConvertor {
        private File b;

        public FileConvertor(File file) {
            this.b = file;
        }

        @Override
        public File asFile() {
            return this.b;
        }

        @Override
        public String asUrl() {
            return null;
        }

        @Override
        public byte[] asBinary() {
            return com.umeng.socialize.a.a.a.a(this.b, UMImage.this.compressFormat);
        }

        @Override
        public Bitmap asBitmap() {
            if (SocializeUtils.assertBinaryInvalid(this.asBinary())) {
                return com.umeng.socialize.a.a.a.a(UMImage.this.asBinImage());
            }
            return null;
        }
    }

    class BitmapConvertor
    extends ConfiguredConvertor {
        private Bitmap b;

        public BitmapConvertor(Bitmap bitmap) {
            this.b = bitmap;
        }

        @Override
        public File asFile() {
            byte[] byArray = com.umeng.socialize.a.a.a.a(this.b, UMImage.this.compressFormat);
            if (SocializeUtils.assertBinaryInvalid(this.asBinary())) {
                return com.umeng.socialize.a.a.a.b(byArray);
            }
            return null;
        }

        @Override
        public String asUrl() {
            return null;
        }

        @Override
        public byte[] asBinary() {
            return com.umeng.socialize.a.a.a.a(this.b, UMImage.this.compressFormat);
        }

        @Override
        public Bitmap asBitmap() {
            return this.b;
        }
    }

    public static enum CompressStyle {
        SCALE,
        QUALITY;

    }
}

