/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.share.sdk.openapi.channel;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.alipay.share.sdk.Constant;
import com.alipay.share.sdk.openapi.channel.MMessageUtil;
import java.util.HashMap;
import java.util.Map;

public class APMessage {
    private static final String TAG = "APSDK.APMessage";

    public static boolean send(Context context, String receiverPermission, String action, String content, Bundle bundle) {
        receiverPermission = String.valueOf(receiverPermission) + ".permission.MM_MESSAGE";
        Intent intent = new Intent(action);
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        String packageName = context.getPackageName();
        intent.putExtra(Constant.EXTRA_MESSAGE_SDK_VERSION, 20150630);
        intent.putExtra(Constant.EXTRA_MESSAGE_APP_PACKAGE_NAME, packageName);
        intent.putExtra(Constant.EXTRA_MESSAGE_CONTENT, content);
        intent.putExtra(Constant.EXTRA_MESSAGE_CHECK_SUM, MMessageUtil.checkSum(content, packageName));
        context.sendBroadcast(intent, receiverPermission);
        Log.d((String)TAG, (String)("send ap message, intent=" + intent + ", perm=" + receiverPermission));
        return true;
    }

    public static void send(Context context, String receiverPermission, String appIdContent) {
        APMessage.send(context, receiverPermission, "com.alipay.sdk.channel.Intent.ACTION_MESSAGE", appIdContent);
    }

    public static void send(Context context, String receiverPermission, String action, String appIdContent) {
        APMessage.send(context, receiverPermission, action, appIdContent, null);
    }

    public static interface CallBack {
        public void handleMessage(Intent var1);
    }

    public static final class Receiver
    extends BroadcastReceiver {
        public static final Map<String, CallBack> callbacks = new HashMap<String, CallBack>();
        private final CallBack callBack;

        public Receiver() {
            this(null);
        }

        public Receiver(CallBack callBack) {
            this.callBack = callBack;
        }

        public final void onReceive(Context context, Intent intent) {
            Log.d((String)APMessage.TAG, (String)("receive intent=" + intent));
            if (this.callBack != null) {
                this.callBack.handleMessage(intent);
                Log.d((String)APMessage.TAG, (String)"mm message self-handled");
            } else {
                CallBack messageCallBack = callbacks.get(intent.getAction());
                if (messageCallBack != null) {
                    messageCallBack.handleMessage(intent);
                    Log.d((String)APMessage.TAG, (String)"mm message handled");
                }
            }
        }

        public static void registerCallBack(String key, CallBack callBack1) {
            callbacks.put(key, callBack1);
        }

        public static void unregisterCallBack(String key) {
            callbacks.remove(key);
        }
    }
}

