/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.utils.SocializeUtils;

public class UMMoreHandler
extends UMSSOHandler {
    private Activity mAct;

    @Override
    public void onCreate(Context context, PlatformConfig.Platform platform) {
        super.onCreate(context, platform);
        this.mAct = (Activity)context;
    }

    @Override
    public boolean share(ShareContent shareContent, UMShareListener uMShareListener) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SEND");
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMImage) {
            intent.setType("image/*");
            UMImage uMImage = (UMImage)shareContent.mMedia;
            if (uMImage.asFileImage().getPath() != null) {
                Uri uri = SocializeUtils.insertImage((Context)this.getContext(), (String)uMImage.asFileImage().getPath());
                intent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            }
        } else {
            intent.setType("text/plain");
        }
        intent.putExtra("android.intent.extra.SUBJECT", shareContent.subject);
        intent.putExtra("android.intent.extra.TEXT", shareContent.mText);
        intent = Intent.createChooser((Intent)intent, (CharSequence)Config.MORE_TITLE);
        intent.addFlags(0x10000000);
        try {
            if (this.mAct != null && !this.mAct.isFinishing()) {
                this.mAct.startActivity(intent);
            }
            uMShareListener.onResult(SHARE_MEDIA.MORE);
        }
        catch (Exception exception) {
            uMShareListener.onError(SHARE_MEDIA.MORE, (Throwable)exception);
        }
        return true;
    }

    @Override
    public void release() {
        super.release();
        this.mAct = null;
    }
}

