/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.Telephony;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.SmsShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.io.File;
import java.util.List;

public final class SmsHandler
extends UMSSOHandler {
    protected String VERSION = "6.8.2";

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        Log.um((String)(p.getName() + " version:" + this.VERSION));
    }

    public boolean share(ShareContent content, UMShareListener listener) {
        return this.shareSms(new SmsShareContent(content), listener);
    }

    private boolean shareSms(SmsShareContent shareContent, final UMShareListener listener) {
        String textContent = shareContent.getText();
        UMImage shareImg = shareContent.getImage();
        if (shareContent.getmStyle() == 16 || shareContent.getmStyle() == 4 || shareContent.getmStyle() == 8) {
            textContent = textContent + shareContent.getBaseMediaObject().toUrl();
        }
        Intent sendIntent = null;
        boolean haveSmsApp = DeviceConfig.isAppInstalled((String)"com.android.mms", (Context)this.getContext());
        if (haveSmsApp) {
            if (shareImg != null) {
                sendIntent = new Intent("android.intent.action.SEND");
                if (haveSmsApp) {
                    try {
                        Class.forName("com.android.mms.ui.ComposeMessageActivity");
                        sendIntent.setClassName("com.android.mms", "com.android.mms.ui.ComposeMessageActivity");
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        sendIntent.setPackage("com.android.mms");
                    }
                }
                Uri imgUri = SocializeUtils.insertImage((Context)this.getContext(), (String)shareImg.asFileImage().getPath());
                sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)imgUri);
                sendIntent.setType("image/*");
                SocializeUtils.deleteUris.add(imgUri);
            } else {
                sendIntent = new Intent("android.intent.action.VIEW");
                sendIntent.setType("vnd.android-dir/mms-sms");
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            String defaultSmsPackageName = Telephony.Sms.getDefaultSmsPackage((Context)this.getContext());
            sendIntent = new Intent("android.intent.action.SEND");
            if (shareImg == null) {
                sendIntent.setType("text/plain");
                sendIntent.putExtra("android.intent.extra.TEXT", textContent);
            } else {
                sendIntent.setType("image/*");
                Uri imgUri = SocializeUtils.insertImage((Context)this.getContext(), (String)shareImg.asFileImage().getPath());
                sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)imgUri);
                sendIntent.putExtra("android.intent.extra.TEXT", textContent);
                SocializeUtils.deleteUris.add(imgUri);
            }
            if (defaultSmsPackageName != null) {
                sendIntent.setPackage(defaultSmsPackageName);
            }
        } else {
            sendIntent = new Intent("android.intent.action.SENDTO", Uri.parse((String)"smsto:"));
            if (shareImg != null) {
                Context context;
                boolean isConsumed;
                sendIntent.setType("image/*");
                if (this.mWeakAct != null && !(isConsumed = this.queryIntentActivitys(context = (Context)this.mWeakAct.get(), sendIntent))) {
                    sendIntent = new Intent("android.intent.action.SEND");
                    sendIntent.setType("image/*");
                    sendIntent.putExtra("android.intent.extra.TEXT", textContent);
                }
                sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)shareImg.asFileImage()));
            }
        }
        sendIntent.putExtra("sms_body", textContent);
        sendIntent.addFlags(0x10000000);
        try {
            if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                ((Activity)this.mWeakAct.get()).startActivity(sendIntent);
            }
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onResult(SHARE_MEDIA.SMS);
                }
            });
        }
        catch (ActivityNotFoundException e) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.SMS, new Throwable(UmengErrorCode.UnKnowCode.getMessage() + e.getMessage()));
                }
            });
        }
        return false;
    }

    private boolean queryIntentActivitys(Context context, Intent intent) {
        if (context != null) {
            try {
                List result = context.getPackageManager().queryIntentActivities(intent, 64);
                if (result != null && !result.isEmpty()) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

