/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.umeng.socialize.shareboard.IndicatorView;
import com.umeng.socialize.shareboard.ShareBoardConfig;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.shareboard.SocializeMenuAdapter;
import com.umeng.socialize.shareboard.SocializeMenuPagerAdapter;
import com.umeng.socialize.shareboard.widgets.SocializePagerAdapter;
import com.umeng.socialize.shareboard.widgets.SocializeViewPager;
import com.umeng.socialize.utils.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;

class UMActionFrame
extends LinearLayout {
    private ShareBoardConfig mConfig;
    private PopupWindow.OnDismissListener mDismissListener;

    public UMActionFrame(Context context) {
        super(context);
    }

    public UMActionFrame(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @TargetApi(value=11)
    public UMActionFrame(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public UMActionFrame(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setSnsPlatformData(List<SnsPlatform> platforms) {
        ShareBoardConfig defaultConfig = new ShareBoardConfig();
        this.setSnsPlatformData(platforms, defaultConfig);
    }

    public void setSnsPlatformData(List<SnsPlatform> platforms, ShareBoardConfig config) {
        this.mConfig = config == null ? new ShareBoardConfig() : config;
        this.init(platforms);
    }

    private void init(List<SnsPlatform> platforms) {
        this.setBackgroundColor(Color.argb((int)50, (int)0, (int)0, (int)0));
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(100L);
        this.setAnimation((Animation)alphaAnimation);
        this.setOrientation(1);
        if (this.mConfig.mShareboardPosition == ShareBoardConfig.SHAREBOARD_POSITION_BOTTOM) {
            this.setGravity(80);
        } else if (this.mConfig.mShareboardPosition == ShareBoardConfig.SHAREBOARD_POSITION_CENTER) {
            this.setGravity(17);
            int leftPadding = this.dip2px(36.0f);
            this.setPadding(leftPadding, 0, leftPadding, 0);
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (UMActionFrame.this.mDismissListener != null) {
                    UMActionFrame.this.mDismissListener.onDismiss();
                }
            }
        });
        View shareMenuLayout = this.createShareboardLayout(platforms);
        if (shareMenuLayout == null) {
            return;
        }
        shareMenuLayout.setClickable(true);
        this.addView(shareMenuLayout);
    }

    private View createShareboardLayout(List<SnsPlatform> platforms) {
        LinearLayout shareMenuLayout = new LinearLayout(this.getContext());
        shareMenuLayout.setBackgroundColor(this.mConfig.mShareboardBgColor);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        if (this.mConfig.mShareboardPosition == ShareBoardConfig.SHAREBOARD_POSITION_CENTER && this.mConfig.mTopMargin != 0) {
            layoutParams.topMargin = this.mConfig.mTopMargin;
        }
        shareMenuLayout.setOrientation(1);
        shareMenuLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mConfig.mTitleVisibility) {
            View titleView = this.createShareTitle();
            shareMenuLayout.addView(titleView);
        }
        int pageHeight = this.mConfig.calculateMenuHeightInDp(platforms.size());
        ViewPager viewPager = this.createViewPagerInstance();
        if (viewPager != null) {
            IndicatorView indicator;
            SocializeMenuPagerAdapter adapter = new SocializeMenuPagerAdapter(this.getContext(), this.mConfig);
            adapter.setData(platforms);
            this.settingMenuLayout((View)viewPager, pageHeight);
            shareMenuLayout.addView((View)viewPager);
            viewPager.setAdapter((PagerAdapter)adapter);
            IndicatorView indicatorView = indicator = this.mConfig.mIndicatorVisibility ? this.createIndicatorView() : null;
            if (indicator != null) {
                indicator.setPageCount(adapter.getCount());
                shareMenuLayout.addView((View)indicator);
            }
            ViewPager.OnPageChangeListener listener = new ViewPager.OnPageChangeListener(){

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                }

                public void onPageSelected(int position) {
                    if (indicator != null) {
                        indicator.setSelectedPosition(position);
                    }
                }

                public void onPageScrollStateChanged(int state) {
                }
            };
            if (this.verifyMethodExists()) {
                viewPager.addOnPageChangeListener(listener);
            } else {
                viewPager.setOnPageChangeListener(listener);
            }
        } else {
            IndicatorView indicator;
            SocializeViewPager socializeViewPager = this.createSocializeViewPagerInstance();
            if (socializeViewPager == null) {
                return null;
            }
            SocializeMenuAdapter adapter = new SocializeMenuAdapter(this.getContext(), this.mConfig);
            adapter.setData(platforms);
            this.settingMenuLayout((View)socializeViewPager, pageHeight);
            shareMenuLayout.addView((View)socializeViewPager);
            socializeViewPager.setAdapter((SocializePagerAdapter)adapter);
            IndicatorView indicatorView = indicator = this.mConfig.mIndicatorVisibility ? this.createIndicatorView() : null;
            if (indicator != null) {
                indicator.setPageCount(adapter.getCount());
                shareMenuLayout.addView((View)indicator);
            }
            socializeViewPager.addOnPageChangeListener(new SocializeViewPager.OnPageChangeListener(){

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                }

                public void onPageSelected(int position) {
                    if (indicator != null) {
                        indicator.setSelectedPosition(position);
                    }
                }

                public void onPageScrollStateChanged(int state) {
                }
            });
        }
        if (this.mConfig.mCancelBtnVisibility) {
            View cancelBtn = this.createCancelBtn();
            shareMenuLayout.addView(cancelBtn);
        }
        return shareMenuLayout;
    }

    private View createShareTitle() {
        TextView title = new TextView(this.getContext());
        title.setText((CharSequence)this.mConfig.mTitleText);
        title.setTextColor(this.mConfig.mTitleTextColor);
        title.setTextSize(16.0f);
        title.setGravity(17);
        title.setMaxLines(1);
        title.setEllipsize(TextUtils.TruncateAt.END);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.topMargin = this.dip2px(20.0f);
        title.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return title;
    }

    private void settingMenuLayout(View viewPager, int pageHeight) {
        int padding = this.dip2px(20.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, this.dip2px(pageHeight));
        layoutParams.topMargin = padding;
        layoutParams.leftMargin = layoutParams.rightMargin = this.dip2px(10.0f);
        viewPager.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        viewPager.setPadding(0, 0, 0, padding);
    }

    public IndicatorView createIndicatorView() {
        int padding = this.dip2px(20.0f);
        IndicatorView indicatorView = new IndicatorView(this.getContext());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.bottomMargin = padding;
        indicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        indicatorView.setIndicatorColor(this.mConfig.mIndicatorNormalColor, this.mConfig.mIndicatorSelectedColor);
        indicatorView.setIndicator(3, 5);
        return indicatorView;
    }

    public View createCancelBtn() {
        TextView cancelBtn = new TextView(this.getContext());
        cancelBtn.setText((CharSequence)this.mConfig.mCancelBtnText);
        cancelBtn.setTextColor(this.mConfig.mCancelBtnColor);
        cancelBtn.setClickable(true);
        cancelBtn.setTextSize(15.0f);
        cancelBtn.setGravity(17);
        if (this.mConfig.mCancelBtnBgPressedColor != 0) {
            if (Build.VERSION.SDK_INT >= 16) {
                cancelBtn.setBackground((Drawable)this.getBtnBg());
            } else {
                cancelBtn.setBackgroundDrawable((Drawable)this.getBtnBg());
            }
        } else {
            cancelBtn.setBackgroundColor(this.mConfig.mCancelBtnBgColor);
        }
        cancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (UMActionFrame.this.mDismissListener != null) {
                    UMActionFrame.this.mDismissListener.onDismiss();
                }
            }
        });
        int height = this.dip2px(50.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, height);
        cancelBtn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return cancelBtn;
    }

    private StateListDrawable getBtnBg() {
        ColorDrawable normalColor = new ColorDrawable(this.mConfig.mCancelBtnBgColor);
        ColorDrawable pressedColor = new ColorDrawable(this.mConfig.mCancelBtnBgPressedColor);
        StateListDrawable bg = new StateListDrawable();
        int pressed = 16842919;
        bg.addState(new int[]{pressed}, (Drawable)pressedColor);
        bg.addState(new int[0], (Drawable)normalColor);
        return bg;
    }

    private int dip2px(float dpValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    void setDismissListener(PopupWindow.OnDismissListener dismissListener) {
        this.mDismissListener = dismissListener;
    }

    private ViewPager createViewPagerInstance() {
        ViewPager viewPager = null;
        try {
            Class<?> viewPagerClass = Class.forName("android.support.v4.view.ViewPager");
            Class[] parTypes = new Class[]{Context.class};
            Constructor<?> constructor = viewPagerClass.getConstructor(parTypes);
            Object[] pars = new Object[]{this.getContext()};
            viewPager = (ViewPager)constructor.newInstance(pars);
            return viewPager;
        }
        catch (Exception e) {
            Log.e((String)("UMActionFrame create ViewPager Instance error:" + e));
            return viewPager;
        }
    }

    private boolean verifyMethodExists() {
        try {
            Class<?> viewPagerClass = Class.forName("android.support.v4.view.ViewPager");
            Method method = viewPagerClass.getMethod("addOnPageChangeListener", ViewPager.OnPageChangeListener.class);
            if (method != null) {
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)("UMActionFrame verifyMethodExists addOnPageChangeListener error:" + e));
        }
        return false;
    }

    private SocializeViewPager createSocializeViewPagerInstance() {
        SocializeViewPager viewPager = null;
        try {
            Class<?> viewPagerClass = Class.forName("com.umeng.socialize.shareboard.widgets.SocializeViewPager");
            Class[] parTypes = new Class[]{Context.class};
            Constructor<?> constructor = viewPagerClass.getConstructor(parTypes);
            Object[] pars = new Object[]{this.getContext()};
            viewPager = (SocializeViewPager)constructor.newInstance(pars);
            return viewPager;
        }
        catch (Exception e) {
            Log.e((String)("UMActionFrame create SocializeViewPager Instance error:" + e));
            Log.um((String)"\u60a8\u7684\u5de5\u7a0b\u9700\u8981\u4f9d\u8d56v4\u6216\u6211\u4eec\u63d0\u4f9bumeng_shareboard_widget\u5305\uff0c\u8bf7\u53c2\u8003\u7ebf\u4e0a\u6587\u6863");
            return viewPager;
        }
    }
}

