/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.shareboard.ShareBoardConfig;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.shareboard.SocializeImageView;
import com.umeng.socialize.utils.Log;
import java.util.ArrayList;
import java.util.List;

class ShareBoardMenuHelper {
    private static String TAG = ShareBoardMenuHelper.class.getSimpleName();
    private ShareBoardConfig mShareBoardConfig;

    public ShareBoardMenuHelper(ShareBoardConfig shareBoardConfig) {
        this.mShareBoardConfig = shareBoardConfig;
    }

    public List<SnsPlatform[][]> formatPageData(List<SnsPlatform> menuData) {
        int pageSize = this.mShareBoardConfig.mMenuColumnNum * 2;
        int menuSize = menuData.size();
        ArrayList<SnsPlatform[][]> result = new ArrayList<SnsPlatform[][]>();
        if (menuSize < this.mShareBoardConfig.mMenuColumnNum) {
            SnsPlatform[][] page = new SnsPlatform[1][menuSize];
            for (int i = 0; i < menuData.size(); ++i) {
                page[0][i] = menuData.get(i);
            }
            result.add(page);
            return result;
        }
        int pageCount = menuSize / pageSize;
        int lastPageRowNum = -1;
        int lastPageMenuSize = menuSize % pageSize;
        if (lastPageMenuSize != 0) {
            lastPageRowNum = lastPageMenuSize / this.mShareBoardConfig.mMenuColumnNum + (lastPageMenuSize % this.mShareBoardConfig.mMenuColumnNum != 0 ? 1 : 0);
            ++pageCount;
        }
        for (int i = 0; i < pageCount; ++i) {
            int rowNum = i == pageCount - 1 && lastPageRowNum != -1 ? lastPageRowNum : 2;
            SnsPlatform[][] page = new SnsPlatform[rowNum][this.mShareBoardConfig.mMenuColumnNum];
            result.add(page);
        }
        int menuCount = 0;
        for (int i = 0; i < result.size(); ++i) {
            for (SnsPlatform[] column : (SnsPlatform[][])result.get(i)) {
                for (int col = 0; col < column.length; ++col) {
                    if (menuCount < menuSize) {
                        column[col] = menuData.get(menuCount);
                    }
                    ++menuCount;
                }
            }
        }
        return result;
    }

    public View createPageLayout(Context context, SnsPlatform[][] pageData) {
        LinearLayout pageLayout = new LinearLayout(context);
        pageLayout.setOrientation(1);
        pageLayout.setGravity(48);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        pageLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        for (int i = 0; i < pageData.length; ++i) {
            SnsPlatform[] rowData = pageData[i];
            View rowView = this.createRowLayout(context, rowData, i != 0);
            pageLayout.addView(rowView);
        }
        return pageLayout;
    }

    private View createRowLayout(Context context, SnsPlatform[] rowData, boolean isHasTopMargin) {
        LinearLayout rowLayout = new LinearLayout(context);
        rowLayout.setOrientation(0);
        rowLayout.setGravity(1);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        if (isHasTopMargin) {
            layoutParams.topMargin = this.dip2px(context, 20.0f);
        }
        rowLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        for (int i = 0; i < rowData.length; ++i) {
            View btn = this.createBtnView(context, rowData[i]);
            rowLayout.addView(btn);
        }
        return rowLayout;
    }

    private View createBtnView(Context context, final SnsPlatform snsPlatform) {
        LinearLayout container = new LinearLayout(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2);
        layoutParams.weight = 1.0f;
        container.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        container.setGravity(17);
        if (snsPlatform != null) {
            ResContainer resContainer = ResContainer.get((Context)context);
            View btn = LayoutInflater.from((Context)context).inflate(resContainer.layout("socialize_share_menu_item"), null);
            SocializeImageView imageView = (SocializeImageView)btn.findViewById(resContainer.id("socialize_image_view"));
            TextView btnText = (TextView)btn.findViewById(resContainer.id("socialize_text_view"));
            if (this.mShareBoardConfig.mMenuBgColor != 0 && this.mShareBoardConfig.mMenuBgShape != ShareBoardConfig.BG_SHAPE_NONE) {
                imageView.setBackgroundColor(this.mShareBoardConfig.mMenuBgColor, this.mShareBoardConfig.mMenuBgPressedColor);
                imageView.setBackgroundShape(this.mShareBoardConfig.mMenuBgShape, this.mShareBoardConfig.mMenuBgShapeAngle);
            } else {
                imageView.setPadding(0, 0, 0, 0);
            }
            if (this.mShareBoardConfig.mMenuIconPressedColor != 0) {
                imageView.setPressedColor(this.mShareBoardConfig.mMenuIconPressedColor);
            }
            String text = "";
            try {
                text = snsPlatform.mShowWord;
            }
            catch (Exception e) {
                SHARE_MEDIA platform = snsPlatform.mPlatform;
                String targetPlat = platform == null ? "" : platform.toString();
                Log.d((String)TAG, (String)("fetch btn str failed,platform is:" + targetPlat));
            }
            if (!TextUtils.isEmpty((CharSequence)text)) {
                btnText.setText((CharSequence)snsPlatform.mShowWord);
            }
            btnText.setGravity(17);
            int rId = 0;
            try {
                rId = ResContainer.getResourceId((Context)context, (String)"drawable", (String)snsPlatform.mIcon);
            }
            catch (Exception e) {
                SHARE_MEDIA platform = snsPlatform.mPlatform;
                String targetPlat = platform == null ? "" : platform.toString();
                Log.d((String)TAG, (String)("fetch icon id failed,platform is:" + targetPlat));
            }
            if (rId != 0) {
                imageView.setImageResource(rId);
            }
            if (this.mShareBoardConfig.mMenuTextColor != 0) {
                btnText.setTextColor(this.mShareBoardConfig.mMenuTextColor);
            }
            btn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SHARE_MEDIA platform = snsPlatform.mPlatform;
                    if (ShareBoardMenuHelper.this.mShareBoardConfig != null && ShareBoardMenuHelper.this.mShareBoardConfig.getShareBoardlistener() != null) {
                        ShareBoardMenuHelper.this.mShareBoardConfig.getShareBoardlistener().onclick(snsPlatform, platform);
                    }
                }
            });
            container.addView(btn);
        }
        return container;
    }

    private int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

