/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.shareboard.ShareBoardConfig;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.shareboard.UMActionFrame;
import com.umeng.socialize.utils.ShareBoardlistener;
import com.umeng.socialize.utils.SocializeSpUtils;
import java.util.List;

public class ShareBoard
extends PopupWindow {
    private ShareBoardConfig mShareBoardConfig;

    public ShareBoard(Context context, List<SnsPlatform> platforms) {
        this(context, platforms, null);
    }

    public ShareBoard(Context context, List<SnsPlatform> platforms, ShareBoardConfig config) {
        super(context);
        this.setWindowLayoutMode(-1, -1);
        boolean isHorizontal = false;
        if (context.getResources().getConfiguration().orientation == 2) {
            isHorizontal = true;
        }
        if (config == null) {
            config = new ShareBoardConfig();
        }
        this.mShareBoardConfig = config;
        config.setOrientation(isHorizontal);
        UMActionFrame umActionBoard = new UMActionFrame(context);
        umActionBoard.setSnsPlatformData(platforms, config);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        umActionBoard.setLayoutParams(params);
        umActionBoard.setDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                ShareBoard.this.dismiss();
            }
        });
        this.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                PopupWindow.OnDismissListener onDismissListener;
                PopupWindow.OnDismissListener onDismissListener2 = onDismissListener = ShareBoard.this.mShareBoardConfig != null ? ShareBoard.this.mShareBoardConfig.getOnDismissListener() : null;
                if (onDismissListener != null) {
                    onDismissListener.onDismiss();
                }
            }
        });
        this.setContentView((View)umActionBoard);
        this.setFocusable(true);
        this.saveShareboardConfig(context, config);
    }

    private void saveShareboardConfig(Context context, ShareBoardConfig config) {
        if (context == null || config == null) {
            return;
        }
        String position = config.mShareboardPosition == ShareBoardConfig.SHAREBOARD_POSITION_BOTTOM ? "0" : "1";
        String shape = null;
        if (config.mMenuBgShape == ShareBoardConfig.BG_SHAPE_NONE) {
            shape = "0";
        } else if (config.mMenuBgShape == ShareBoardConfig.BG_SHAPE_CIRCULAR) {
            shape = "1";
        } else if (config.mMenuBgShape == ShareBoardConfig.BG_SHAPE_ROUNDED_SQUARE) {
            shape = config.mMenuBgShapeAngle != 0 ? "2" : "3";
        }
        if (!TextUtils.isEmpty((CharSequence)position) || !TextUtils.isEmpty((CharSequence)shape)) {
            SocializeSpUtils.putShareBoardConfig((Context)context, (String)(shape + ";" + position));
        }
    }

    public void setShareBoardlistener(final ShareBoardlistener shareBoardlistener) {
        if (this.mShareBoardConfig == null) {
            return;
        }
        ShareBoardlistener wrapListener = new ShareBoardlistener(){

            public void onclick(SnsPlatform snsPlatform, SHARE_MEDIA share_media) {
                ShareBoard.this.setOnDismissListener(null);
                ShareBoard.this.dismiss();
                if (shareBoardlistener != null) {
                    shareBoardlistener.onclick(snsPlatform, share_media);
                }
            }
        };
        this.mShareBoardConfig.setShareBoardlistener(wrapListener);
    }
}

