/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.common;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import com.umeng.socialize.utils.UmengText;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ResContainer {
    private static ResContainer R = null;
    private Map<String, Integer> map = new HashMap<String, Integer>();
    private Context context = null;
    private Map<String, SocializeResource> mResources;
    private static String mPackageName = "";

    private ResContainer(Context context) {
        this.context = context.getApplicationContext();
    }

    public static synchronized ResContainer get(Context context) {
        if (R == null) {
            R = new ResContainer(context);
        }
        return R;
    }

    public int layout(String string) {
        return ResContainer.getResourceId(this.context, "layout", string);
    }

    public int id(String string) {
        return ResContainer.getResourceId(this.context, "id", string);
    }

    public int drawable(String string) {
        return ResContainer.getResourceId(this.context, "drawable", string);
    }

    public int style(String string) {
        return ResContainer.getResourceId(this.context, "style", string);
    }

    public int string(String string) {
        return ResContainer.getResourceId(this.context, "string", string);
    }

    public int color(String string) {
        return ResContainer.getResourceId(this.context, "color", string);
    }

    public int dimen(String string) {
        return ResContainer.getResourceId(this.context, "dimen", string);
    }

    public int raw(String string) {
        return ResContainer.getResourceId(this.context, "raw", string);
    }

    public int anim(String string) {
        return ResContainer.getResourceId(this.context, "anim", string);
    }

    public int styleable(String string) {
        return ResContainer.getResourceId(this.context, "styleable", string);
    }

    public ResContainer(Context context, Map<String, SocializeResource> map) {
        this.mResources = map;
        this.context = context;
    }

    public static int getResourceId(Context context, String string, String string2) {
        int n;
        Resources resources = context.getResources();
        if (TextUtils.isEmpty((CharSequence)mPackageName)) {
            mPackageName = context.getPackageName();
        }
        if ((n = resources.getIdentifier(string2, string, mPackageName)) <= 0) {
            throw new RuntimeException(UmengText.errorWithUrl(UmengText.resError(mPackageName, string, string2), "https://at.umeng.com/KzKfWz?cid=476"));
        }
        return n;
    }

    public static String getString(Context context, String string) {
        int n = ResContainer.getResourceId(context, "string", string);
        return context.getString(n);
    }

    public synchronized Map<String, SocializeResource> batch() {
        if (this.mResources == null) {
            return this.mResources;
        }
        Set<String> set = this.mResources.keySet();
        for (String string : set) {
            SocializeResource socializeResource = this.mResources.get(string);
            socializeResource.mId = ResContainer.getResourceId(this.context, socializeResource.mType, socializeResource.mName);
            socializeResource.mIsCompleted = true;
        }
        return this.mResources;
    }

    public static int[] getStyleableArrts(Context context, String string) {
        return ResContainer.getResourceDeclareStyleableIntArray(context, string);
    }

    private static final int[] getResourceDeclareStyleableIntArray(Context context, String string) {
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = Class.forName(context.getPackageName() + ".R$styleable").getFields()) {
                if (!field.getName().equals(string)) continue;
                int[] nArray = (int[])field.get(null);
                return nArray;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static class SocializeResource {
        public String mType;
        public String mName;
        public boolean mIsCompleted = false;
        public int mId;

        public SocializeResource(String string, String string2) {
            this.mType = string;
            this.mName = string2;
        }
    }
}

