/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.text.TextUtils;
import com.sina.weibo.sdk.api.ImageObject;
import com.sina.weibo.sdk.api.TextObject;
import com.sina.weibo.sdk.api.WebpageObject;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.utils.Utility;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.net.LinkCardResponse;
import com.umeng.socialize.net.LinkcardRequest;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.UmengText;

public class SinaShareContent
extends SimpleShareContent {
    public SinaShareContent(ShareContent shareContent) {
        super(shareContent);
    }

    public WeiboMultiMessage getMessage() {
        WeiboMultiMessage weiboMessage = new WeiboMultiMessage();
        if (this.getmStyle() == 2 || this.getmStyle() == 3) {
            weiboMessage.imageObject = this.getImageObj();
            if (!TextUtils.isEmpty((CharSequence)this.getText())) {
                weiboMessage.textObject = this.getTextObj();
            }
        } else if (this.getmStyle() == 16) {
            weiboMessage.mediaObject = this.getWebpageObj();
            this.addText(weiboMessage);
        } else if (this.getmStyle() == 4) {
            weiboMessage.mediaObject = this.getMusicObj();
            this.addText(weiboMessage);
        } else if (this.getmStyle() == 8) {
            weiboMessage.mediaObject = this.getVideoObj();
            this.addText(weiboMessage);
        } else {
            weiboMessage.textObject = this.getTextObj();
        }
        return weiboMessage;
    }

    private WeiboMultiMessage addText(WeiboMultiMessage message) {
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            message.textObject = this.getTextObj();
        } else {
            TextObject textObject = new TextObject();
            if (this.getBaseMediaObject() != null && !TextUtils.isEmpty((CharSequence)this.getBaseMediaObject().getDescription())) {
                textObject.text = this.getBaseMediaObject().getDescription();
            }
            message.textObject = textObject;
        }
        return message;
    }

    private WeiboMultiMessage addImage(WeiboMultiMessage message) {
        if (this.getBaseMediaObject() != null && this.getBaseMediaObject().getThumbImage() != null) {
            ImageObject imageObject = new ImageObject();
            if (this.canFileValid(this.getBaseMediaObject().getThumbImage())) {
                imageObject.imagePath = this.getBaseMediaObject().getThumbImage().asFileImage().toString();
            } else {
                imageObject.imageData = this.getImageData(this.getBaseMediaObject().getThumbImage());
            }
            message.imageObject = imageObject;
        }
        return message;
    }

    private TextObject getTextObj() {
        TextObject textObject = new TextObject();
        textObject.text = this.getText();
        return textObject;
    }

    private ImageObject getImageObj() {
        ImageObject imageObject = new ImageObject();
        if (this.canFileValid(this.getImage())) {
            imageObject.imagePath = this.getImage().asFileImage().toString();
        } else {
            imageObject.imageData = this.getImageData(this.getImage());
        }
        imageObject.thumbData = this.objectSetThumb((BaseMediaObject)this.getImage());
        imageObject.description = this.getText();
        return imageObject;
    }

    private WebpageObject getWebpageObj() {
        LinkcardRequest request = new LinkcardRequest(ContextUtil.getContext());
        request.setMedia((BaseMediaObject)this.getUmWeb());
        LinkCardResponse response = RestAPI.convertLinkCard((LinkcardRequest)request);
        WebpageObject mediaObject = new WebpageObject();
        mediaObject.identify = Utility.generateGUID();
        mediaObject.title = this.objectSetTitle((BaseMediaObject)this.getUmWeb());
        mediaObject.description = this.objectSetDescription((BaseMediaObject)this.getUmWeb());
        if (this.getUmWeb().getThumbImage() != null) {
            mediaObject.thumbData = this.objectSetThumb((BaseMediaObject)this.getUmWeb());
        } else {
            Log.um((String)UmengText.SINA_THUMB_ERROR);
        }
        if (response != null) {
            Log.e((String)("xxxxxx response=" + response.mMsg));
        }
        mediaObject.actionUrl = response != null && !TextUtils.isEmpty((CharSequence)response.url) ? response.url : this.getUmWeb().toUrl();
        mediaObject.defaultText = this.getText();
        return mediaObject;
    }

    private WebpageObject getMusicObj() {
        WebpageObject musicObject = new WebpageObject();
        musicObject.identify = Utility.generateGUID();
        musicObject.title = this.objectSetTitle((BaseMediaObject)this.getMusic());
        musicObject.description = this.objectSetDescription((BaseMediaObject)this.getMusic());
        if (this.getMusic().getThumbImage() != null) {
            musicObject.thumbData = this.objectSetThumb((BaseMediaObject)this.getMusic());
        } else {
            Log.um((String)UmengText.SINA_THUMB_ERROR);
        }
        musicObject.actionUrl = this.getMusic().getmTargetUrl();
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            musicObject.defaultText = this.getText();
        }
        return musicObject;
    }

    private WebpageObject getVideoObj() {
        WebpageObject videoObject = new WebpageObject();
        videoObject.identify = Utility.generateGUID();
        videoObject.title = this.objectSetTitle((BaseMediaObject)this.getVideo());
        videoObject.description = this.objectSetDescription((BaseMediaObject)this.getVideo());
        if (this.getVideo().getThumbImage() != null) {
            videoObject.thumbData = this.objectSetThumb((BaseMediaObject)this.getVideo());
        } else {
            Log.um((String)UmengText.SINA_THUMB_ERROR);
        }
        videoObject.actionUrl = this.getVideo().toUrl();
        if (!TextUtils.isEmpty((CharSequence)this.getVideo().getDescription())) {
            videoObject.description = this.getVideo().getDescription();
        }
        videoObject.defaultText = this.getText();
        return videoObject;
    }
}

