/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.sina.weibo.sdk.WbSdk;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.auth.AccessTokenKeeper;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WbAppInfo;
import com.sina.weibo.sdk.auth.WbAuthListener;
import com.sina.weibo.sdk.auth.WbConnectErrorMessage;
import com.sina.weibo.sdk.auth.sso.SsoHandler;
import com.sina.weibo.sdk.share.WbShareHandler;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.SinaPreferences;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.SinaShareContent;
import com.umeng.socialize.media.WBShareCallBackActivity;
import com.umeng.socialize.net.DeleteRequest;
import com.umeng.socialize.net.DeleteResponse;
import com.umeng.socialize.net.UserinfoRequest;
import com.umeng.socialize.net.UserinfoResponse;
import com.umeng.socialize.net.base.SocializeClient;
import com.umeng.socialize.net.utils.URequest;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UmengText;
import java.util.Map;

public class SinaSsoHandler
extends UMSSOHandler {
    private static final String TAG = "SinaSsoHandler";
    private static final int REQUEST_CODE = 5659;
    private PlatformConfig.APPIDPlatform config = null;
    private SinaPreferences sinaPreferences;
    private UMShareListener shareListener;
    private AuthListener mAuthListener;
    private Context mContext;
    protected String VERSION = "6.8.2";
    private SsoHandler mSsoHandler;
    private AuthInfo mAuthInfo;
    private static final String SCOPE = "email,direct_messages_read,direct_messages_write,friendships_groups_read,friendships_groups_write,statuses_to_me_read,follow_app_official_microblog,invitation_write";
    private WbShareHandler shareHandler;
    private WeiboMultiMessage message;
    private static final String REQUEST_USERINFO = "https://api.weibo.com/2/users/show.json";
    private static final String USERNAME = "userName";

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.mContext = context.getApplicationContext();
        this.config = (PlatformConfig.APPIDPlatform)p;
        this.sinaPreferences = new SinaPreferences(this.mContext, "sina");
        this.mAuthInfo = new AuthInfo(context, ((PlatformConfig.APPIDPlatform)p).appId, ((PlatformConfig.APPIDPlatform)this.getConfig()).redirectUrl, SCOPE);
        if (!(context instanceof Activity)) {
            return;
        }
        WbSdk.install((Context)context, (AuthInfo)this.mAuthInfo);
        this.mSsoHandler = new SsoHandler((Activity)context);
        this.shareHandler = new WbShareHandler((Activity)context);
        this.shareHandler.registerApp();
        Log.um((String)("sina full version:" + this.VERSION));
        Log.e((String)TAG, (String)("handleid=" + (Object)((Object)this)));
    }

    public WbShareHandler getWbHandler() {
        return this.shareHandler;
    }

    public WeiboMultiMessage getMessage() {
        return this.message;
    }

    public boolean isInstall() {
        return this.isClientInstalled();
    }

    public boolean isAuthorize() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.isAuthorized();
        }
        return false;
    }

    private boolean isClientInstalled() {
        WbAppInfo wbAppInfo = WeiboAppManager.getInstance((Context)((Context)this.mWeakAct.get())).getWbAppInfo();
        return wbAppInfo != null && wbAppInfo.isLegal();
    }

    public boolean isSupport() {
        return true;
    }

    public String getSDKVersion() {
        return "3.1.4";
    }

    public void authorize(UMAuthListener listener) {
        this.mAuthListener = new AuthListener(listener);
        if (this.mSsoHandler != null) {
            if (this.getShareConfig().isSinaAuthWithWebView()) {
                this.mSsoHandler.authorizeWeb((WbAuthListener)this.mAuthListener);
            } else {
                this.mSsoHandler.authorize((WbAuthListener)this.mAuthListener);
            }
        }
    }

    private void userinfo(final UMAuthListener listener) {
        UserinfoRequest request = new UserinfoRequest(this.getUID(), this.getmAccessToken(), this.config.appId);
        UserinfoResponse response = (UserinfoResponse)new SocializeClient().execute((URequest)request);
        if (response == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.SINA, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed + UmengText.SINA_GET_ERROR));
                }
            });
            return;
        }
        final Map<String, String> map = response.result;
        if (map != null && !map.containsKey("error")) {
            map.put("iconurl", map.get("profile_image_url"));
            map.put("name", map.get("screen_name"));
            map.put("gender", this.getGender(map.get("gender")));
            if (this.sinaPreferences != null) {
                map.put("uid", this.sinaPreferences.getUID());
                map.put("access_token", this.sinaPreferences.getmAccessToken());
                map.put("refreshToken", this.sinaPreferences.getmRefreshToken());
                map.put("expires_in", String.valueOf(this.sinaPreferences.getmTTL()));
                map.put("accessToken", this.sinaPreferences.getmAccessToken());
                map.put("refreshToken", this.sinaPreferences.getmRefreshToken());
                map.put("expiration", String.valueOf(this.sinaPreferences.getmTTL()));
                QueuedWork.runInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        listener.onComplete(SHARE_MEDIA.SINA, 2, map);
                    }
                });
            }
        } else if (map != null) {
            if (this.sinaPreferences != null) {
                this.sinaPreferences.delete();
            }
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.SINA, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed + ((String)map.get("error")).toString()));
                }
            });
        } else {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.SINA, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed + UmengText.DATA_EMPTY));
                }
            });
        }
    }

    public void getPlatformInfo(UMAuthListener listener) {
        if (!this.getShareConfig().isNeedAuthOnGetUserInfo() && this.sinaPreferences.isAuthValid()) {
            this.userinfo(listener);
        } else {
            this.authAndFetchUserInfo(listener);
        }
    }

    private void authAndFetchUserInfo(final UMAuthListener listener) {
        this.authorize(new UMAuthListener(){

            public void onStart(SHARE_MEDIA platform) {
            }

            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                QueuedWork.runInBack((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SinaSsoHandler.this.userinfo(listener);
                    }
                }, (boolean)false);
            }

            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                listener.onError(platform, action, t);
            }

            public void onCancel(SHARE_MEDIA platform, int action) {
                listener.onCancel(platform, action);
            }
        });
    }

    private String getUID() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.getUID();
        }
        return "";
    }

    private String getmAccessToken() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.getmAccessToken();
        }
        return "";
    }

    private String getmRefreshToken() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.getmRefreshToken();
        }
        return "";
    }

    private long getmTTL() {
        if (this.sinaPreferences != null) {
            return this.sinaPreferences.getmTTL();
        }
        return 0L;
    }

    public void deleteAuth(final UMAuthListener listener) {
        DeleteRequest request = new DeleteRequest(this.config.appId, this.getmAccessToken());
        if (this.sinaPreferences != null) {
            this.sinaPreferences.delete();
        }
        DeleteResponse response = (DeleteResponse)new SocializeClient().execute((URequest)request);
        AccessTokenKeeper.clear((Context)ContextUtil.getContext());
        if (this.sinaPreferences != null) {
            this.sinaPreferences.delete();
        }
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                listener.onComplete(SinaSsoHandler.this.getConfig().getName(), 1, null);
            }
        });
    }

    public boolean share(ShareContent content, UMShareListener listener) {
        SinaShareContent mSharecontent = new SinaShareContent(content);
        this.message = mSharecontent.getMessage();
        this.shareListener = listener;
        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
            Intent intent = new Intent((Context)this.mWeakAct.get(), WBShareCallBackActivity.class);
            ((Activity)this.mWeakAct.get()).startActivity(intent);
        }
        return true;
    }

    private void setAuthData(Bundle bundle) {
        if (this.sinaPreferences != null) {
            this.sinaPreferences.setAuthData(bundle).commit();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mSsoHandler != null) {
            this.mSsoHandler.authorizeCallBack(requestCode, resultCode, data);
        }
        this.mSsoHandler = null;
    }

    public boolean isSupportAuth() {
        return true;
    }

    public int getRequestCode() {
        return 5659;
    }

    public void onSuccess() {
        if (this.shareListener != null) {
            this.shareListener.onResult(SHARE_MEDIA.SINA);
        }
    }

    public void onError() {
        if (this.shareListener != null) {
            this.shareListener.onError(SHARE_MEDIA.SINA, new Throwable(UmengErrorCode.ShareFailed.getMessage()));
        }
    }

    public void onCancel() {
        if (this.shareListener != null) {
            this.shareListener.onCancel(SHARE_MEDIA.SINA);
        }
    }

    private Bundle tokenToBundle(Oauth2AccessToken oauth2AccessToken) {
        Bundle bundle = new Bundle();
        bundle.putString(USERNAME, oauth2AccessToken.getUid());
        bundle.putString("uid", oauth2AccessToken.getUid());
        bundle.putString("access_token", oauth2AccessToken.getToken());
        bundle.putString("refresh_token", oauth2AccessToken.getRefreshToken());
        bundle.putString("expires_in", oauth2AccessToken.getExpiresTime() + "");
        return bundle;
    }

    public void release() {
        super.release();
        this.mSsoHandler = null;
    }

    class AuthListener
    implements WbAuthListener {
        private UMAuthListener mListener = null;

        AuthListener(UMAuthListener listener) {
            this.mListener = listener;
        }

        public void onSuccess(Oauth2AccessToken oauth2AccessToken) {
            Bundle values = SinaSsoHandler.this.tokenToBundle(oauth2AccessToken);
            SinaSsoHandler.this.setAuthData(values);
            if (this.mListener != null) {
                values.putString("aid", ((SinaSsoHandler)SinaSsoHandler.this).config.appId);
                values.putString("as", ((SinaSsoHandler)SinaSsoHandler.this).config.appkey);
                values.putString("name", values.getString(SinaSsoHandler.USERNAME));
                values.putString("accessToken", values.getString("access_token"));
                values.putString("refreshToken", values.getString("refresh_token"));
                values.putString("expiration", values.getString("expires_in"));
                this.mListener.onComplete(SHARE_MEDIA.SINA, 0, SocializeUtils.bundleTomap((Bundle)values));
            }
        }

        public void cancel() {
            if (this.mListener != null) {
                this.mListener.onCancel(SHARE_MEDIA.SINA, 0);
            }
        }

        public void onFailure(WbConnectErrorMessage wbConnectErrorMessage) {
            if (this.mListener != null) {
                this.mListener.onError(SHARE_MEDIA.SINA, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + wbConnectErrorMessage.getErrorMessage()));
            }
        }
    }
}

